﻿<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Stany magazynowe</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<script runat="server">
	 
        public class Rekord {
            readonly string magazyn;

            public Rekord(string magazyn, Quantity stan, decimal wartość) {
                this.magazyn = magazyn;
                this.stan = stan;
                this.wartość = wartość;
            }

            public string Magazyn {
                get { return magazyn; }
            }

            private string kod = "";

            public string Kod {
                get { return kod; }
                set { kod = value; }
            }

            private string nazwa = "";

            public string Nazwa {
                get { return nazwa; }
                set { nazwa = value; }
            }

            private Quantity stan;

            public Quantity Stan {
                get { return stan; }
            }

            private decimal wartość;

            public decimal Wartość {
                get { return wartość; }
            }

            public int lp;

            public string LP {
                get { return lp==0 ? "" : lp.ToString(); }
            }
            	
        }      
	 
        ArrayList magazyny;
        string magazyny_ = "";
        StanMagazynuWorker smw;
        int licznik;   
	
        protected void dc_ContextLoad(object sender, EventArgs e) {
            
            ObrotyParams op = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;                       
                        
            MagazynyModule mm = MagazynyModule.GetInstance(dc);                        
                
            magazyny = new ArrayList();
            foreach (Magazyn magazyn in mm.Magazyny.GetGrantedView()) {
                if (mm.Zasoby.WgMagazyn[magazyn].IsEmpty) continue;
                magazyny.Add(magazyn);
                magazyny_ += magazyn.Nazwa.Replace("&", "&amp;") + ", ";
            }
            smw = null;
            
            magazyny_ = magazyny_.Trim(new char[] { ',', ' '});            
            this.ReportHeader.Title = String.Format("Stany magazynowe|</STRONG>Okres magazynowy:<STRONG> {0}|</STRONG>Magazyn:<STRONG> {1}|</STRONG>Dostawca:<STRONG> {2}|</STRONG>Stan na dzień:<STRONG> {3:b}", op.Okres, magazyny_, op.Dostawca, op.DataStanu);            
            
            Grid.AllowPrepareView = false;
            licznik = 0;
        }

        
        protected void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
            if (args.Deep != 1) return;
            Towar towar = (Towar)args.Row;

            if (smw == null)
                smw = (StanMagazynuWorker)
					dc.Context.CreateObject(null, typeof(StanMagazynuWorker), towar);
            else
                smw.Towar = towar;
            ArrayList list = new ArrayList();

            Quantity stanRazem = Quantity.Zero;
            decimal wartośćRazem = 0;
            foreach (Magazyn magazyn in magazyny) {
                smw.Magazyn = magazyn;
                Quantity stan = smw.StanMagazynu;
                if (!stan.IsZero) {
                    list.Add(new Rekord(magazyn.ToString(), stan, smw.WartośćMagazynu));
                    stanRazem += stan;
                    wartośćRazem += smw.WartośćMagazynu;
                }
            }

            if (list.Count > 1)
                list.Insert(0, new Rekord("=== RAZEM ===", stanRazem, wartośćRazem));

            if (list.Count > 0) {
                Rekord rek = (Rekord)list[0];
                rek.Kod = towar.Kod;
                rek.Nazwa = towar.Nazwa;
                rek.lp = ++licznik;
            }

            args.Enumerable = list;
        }

        protected void Grid_BeforeRow(object sender, RowEventArgs args) {
            Rekord rek = (Rekord)args.Row;
            if (rek.Nazwa != "") {
                colStan.Format = "<b>{0}</b>";
                colWartość.Format = "<b>{0:n}</b>";
            }
            else {
                colStan.Format = "";
                colWartość.Format = "{0:n}";
            }
        }
	    
</script>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" Title="Stany magazynowe|</STRONG>"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" OnItemsGet="Grid_ItemsGet" OnBeforeRow="Grid_BeforeRow">
				<Columns>
                    <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="LP" Width="5"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Left" DataMember="Kod" Caption="Towar~Kod" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Nazwa" Caption="Towar~Nazwa" runat="server" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="Magazyn" Caption="Magazyn" Width="25" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" DataMember="Stan" Caption="Ilość" runat="server" ID="colStan"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Right" DataMember="Wartość" Caption="Wartość" Format="{0:n}" runat="server" ID="colWartość"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true"></eb:ReportFooter>
		</form>
	</body>
</HTML>

